Scriptname RF:OverheatScript Extends ActiveMagicEffect

RF:TravelHandlerQuest Property TravelManager Mandatory Const Auto
RF:TutorialQuest Property TutorialManager Mandatory Const Auto

Message Property TheMessageOnSTart Mandatory Const Auto
Message Property TheMessageGoodToGo Mandatory Const Auto
Message Property TheMessageFailedToRepair Mandatory Const Auto

WwiseEvent Property TheSoundOnFail Mandatory Const Auto
WwiseEvent Property TheSoundOnOK Mandatory Const Auto

Spell Property TheOverheatSpell Mandatory Const Auto

ActorValue Property SpaceshipGravDriveHealth Mandatory Const Auto
{ I may as well do this here to avoid jumping around... it's relevant after all }

bool Running = false ; avoid notif spam on recast if we fail to conduct repairs

Event OnEffectStart(ObjectReference akTarget, Actor akCaster, MagicEffect akBaseEffect, float afMagnitude, float afDuration)
    TravelManager.DBG("Overheat: OnEffectStart")
    If !Running
        Utility.Wait(3)
        TravelManager.DamageValueSafe(SpaceshipGravDriveHealth, 4.75) ; This was a bit egregious but cool
        TravelManager.DisableFar(true)
        TravelManager.DisableGrav(true) ; I may run this one on the fast travel layer if this does not work
        TheSoundOnFail.Play(akCaster)
        ;TutorialManager.HelpMessage(TheMessageOnSTart) ; Check if this is too specific to call from Disaster. Maybe use another spell, idk
        Running = True
    EndIF
EndEvent

Event OnEffectFinish(ObjectReference akTarget, Actor akCaster, MagicEffect akBaseEffect, float afMagnitude, float afDuration)
    TravelManager.DBG("Overheat: OnEffectFinish")
    If TravelManager.HandleOverheatEnd() ; returns true if we fixed the grav drive. nothing else currently
        TravelManager.DBG("Overheat: HandleEnd True")
        TravelManager.DisableFar(false)
        TravelManager.DisableGrav(false)
        TutorialManager.HelpMessage(TheMessageGoodToGo)
        TheSoundOnOK.Play(akCaster)
    Else
        TravelManager.DBG("Overheat: HandleEnd False")
        ;TheSoundOnFail.Play(akCaster)
        TheOverheatSpell.Cast(akCaster)
        TutorialManager.HelpMessage(TheMessageFailedToRepair)
        ; This will silently reset the event and keep FT disabled.
    EndIf
EndEvent